<?php
/**
 * Run Scoring Endpoint
 * Manually trigger a scoring run
 */

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../services/YahooFinanceService.php';
require_once __DIR__ . '/../services/ScoringService.php';

// Only accept POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Method not allowed']);
    exit;
}

try {
    $today = date('Y-m-d');
    $yesterday = date('Y-m-d', strtotime('-1 day'));

    // 1. Fetch today's market data
    $yahooService = new YahooFinanceService();
    $marketData = $yahooService->fetchAllEuropeanIndices();

    // 2. Save market data
    $scoringService = new ScoringService();
    $scoringService->saveMarketData($today, $marketData);

    // 3. Score yesterday's predictions
    $scores = $scoringService->scorePredictions($yesterday, $today);

    echo json_encode([
        'success' => true,
        'date' => $today,
        'total_predictions' => $scores['total_predictions'],
        'correct_predictions' => $scores['correct_predictions'],
        'accuracy_percent' => $scores['accuracy_percent']
    ]);

} catch (Exception $e) {
    error_log("Scoring run failed: " . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
