<?php
/**
 * Scores Endpoint
 * Returns historical accuracy scores
 */

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../services/ScoringService.php';

try {
    $limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 30;
    $limit = max(1, min($limit, 365)); // Between 1 and 365

    $scoringService = new ScoringService();
    $scores = $scoringService->getHistoricalScores($limit);

    echo json_encode([
        'success' => true,
        'count' => count($scores),
        'data' => $scores,
        'timestamp' => date('c')
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
