<?php
/**
 * Daily Prediction Cron Job
 * Run this script daily at 6 PM CET to generate predictions
 */

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../services/YahooFinanceService.php';
require_once __DIR__ . '/../services/GoogleNewsService.php';
require_once __DIR__ . '/../services/ClaudeAIService.php';
require_once __DIR__ . '/../services/ScoringService.php';

echo "========================================\n";
echo "Running Daily Prediction Task\n";
echo "Time: " . date('c') . "\n";
echo "========================================\n\n";

try {
    $today = date('Y-m-d');
    $tomorrow = date('Y-m-d', strtotime('+1 day'));

    // 1. Fetch market data
    echo "Fetching market data...\n";
    $yahooService = new YahooFinanceService();
    $marketData = $yahooService->fetchAllEuropeanIndices();
    echo "Fetched data for " . count($marketData) . " indices\n\n";

    // 2. Fetch news
    echo "Fetching news articles...\n";
    $newsService = new GoogleNewsService();
    $newsArticles = $newsService->fetchEuropeanMarketNews();
    echo "Fetched " . count($newsArticles) . " news articles\n\n";

    // 3. Generate predictions
    echo "Generating predictions with Claude AI...\n";
    $claudeService = new ClaudeAIService();
    $predictions = $claudeService->generatePredictions($marketData, $newsArticles);
    echo "Predictions generated successfully\n\n";

    // 4. Save to database
    echo "Saving data to database...\n";
    $scoringService = new ScoringService();

    $scoringService->saveMarketData($today, $marketData);
    echo "Market data saved\n";

    $scoringService->saveNewsArticles($today, $newsArticles);
    echo "News articles saved\n";

    $scoringService->savePredictions($today, $tomorrow, $predictions);
    echo "Predictions saved\n\n";

    echo "========================================\n";
    echo "Daily Prediction Task Completed\n";
    echo "========================================\n";

    exit(0);

} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    echo $e->getTraceAsString() . "\n";
    exit(1);
}
