#!/bin/bash

# Fix Apache Configuration for traider.antoinepelloux.eu
# This script will replace the existing Apache configuration

echo "=========================================="
echo "Fixing Apache Configuration"
echo "=========================================="

# Backup existing configuration
echo "1. Backing up existing configuration..."
if [ -f /etc/apache2/sites-available/004-traider.antoinepelloux.eu.conf ]; then
    sudo cp /etc/apache2/sites-available/004-traider.antoinepelloux.eu.conf /etc/apache2/sites-available/004-traider.antoinepelloux.eu.conf.backup
    echo "   ✓ Backup created"
else
    echo "   ! Original config not found at expected location"
fi

# Copy new configuration
echo "2. Installing new configuration..."
sudo cp /home/antoine/server_files/traider.antoinepelloux.eu/apache-config/004-traider.antoinepelloux.eu.conf /etc/apache2/sites-available/
echo "   ✓ Configuration copied"

# Enable the site if not already enabled
echo "3. Enabling site..."
sudo a2ensite 004-traider.antoinepelloux.eu.conf
echo "   ✓ Site enabled"

# Test Apache configuration
echo "4. Testing Apache configuration..."
if sudo apache2ctl configtest; then
    echo "   ✓ Configuration test passed"
else
    echo "   ✗ Configuration test failed!"
    echo "   Restoring backup..."
    if [ -f /etc/apache2/sites-available/004-traider.antoinepelloux.eu.conf.backup ]; then
        sudo cp /etc/apache2/sites-available/004-traider.antoinepelloux.eu.conf.backup /etc/apache2/sites-available/004-traider.antoinepelloux.eu.conf
    fi
    exit 1
fi

# Reload Apache
echo "5. Reloading Apache..."
sudo systemctl reload apache2
echo "   ✓ Apache reloaded"

# Check if Node.js service is running
echo "6. Checking Node.js service status..."
if sudo systemctl is-active --quiet stock-predictor; then
    echo "   ✓ Node.js service is running"
else
    echo "   ! Node.js service is NOT running"
    echo "   Starting Node.js service..."
    sudo systemctl start stock-predictor
    if sudo systemctl is-active --quiet stock-predictor; then
        echo "   ✓ Node.js service started"
    else
        echo "   ✗ Failed to start Node.js service"
        echo "   Check logs with: sudo journalctl -u stock-predictor -n 50"
    fi
fi

echo ""
echo "=========================================="
echo "Configuration Fixed!"
echo "=========================================="
echo ""
echo "Your site should now be accessible at:"
echo "  → http://traider.antoinepelloux.eu"
echo ""
echo "To check for errors:"
echo "  → Apache errors: sudo tail -f /var/log/apache2/traider-error.log"
echo "  → Node.js logs: sudo journalctl -u stock-predictor -f"
echo ""
