<?php
/**
 * Market Data Endpoint
 * Returns current European market data
 */

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../services/YahooFinanceService.php';

try {
    $yahooService = new YahooFinanceService();
    $marketData = $yahooService->fetchAllEuropeanIndices();

    echo json_encode([
        'success' => true,
        'count' => count($marketData),
        'data' => $marketData,
        'timestamp' => date('c')
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
