<?php
/**
 * News Endpoint
 * Returns recent financial news
 */

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../services/GoogleNewsService.php';

try {
    $newsService = new GoogleNewsService();
    $news = $newsService->fetchEuropeanMarketNews();

    echo json_encode([
        'success' => true,
        'count' => count($news),
        'data' => $news,
        'timestamp' => date('c')
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
