<?php
/**
 * Predictions Endpoint
 * Returns latest predictions with scores
 */

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../services/ScoringService.php';

try {
    $scoringService = new ScoringService();
    $predictions = $scoringService->getLatestPredictionsWithScores();

    $predictionsUp = array_filter($predictions, function($p) {
        return $p['prediction_type'] === 'UP';
    });

    $predictionsDown = array_filter($predictions, function($p) {
        return $p['prediction_type'] === 'DOWN';
    });

    $predictionDate = !empty($predictions) ? $predictions[0]['prediction_date'] : null;

    echo json_encode([
        'success' => true,
        'prediction_date' => $predictionDate,
        'predictions_up' => array_values($predictionsUp),
        'predictions_down' => array_values($predictionsDown),
        'timestamp' => date('c')
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
