<?php
/**
 * Run Prediction Endpoint
 * Manually trigger a prediction run
 */

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../services/YahooFinanceService.php';
require_once __DIR__ . '/../services/GoogleNewsService.php';
require_once __DIR__ . '/../services/ClaudeAIService.php';
require_once __DIR__ . '/../services/ScoringService.php';

// Only accept POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Method not allowed']);
    exit;
}

try {
    $today = date('Y-m-d');
    $tomorrow = date('Y-m-d', strtotime('+1 day'));

    // 1. Fetch market data
    $yahooService = new YahooFinanceService();
    $marketData = $yahooService->fetchAllEuropeanIndices();

    // 2. Fetch news
    $newsService = new GoogleNewsService();
    $newsArticles = $newsService->fetchEuropeanMarketNews();

    // 3. Generate predictions
    $claudeService = new ClaudeAIService();
    $predictions = $claudeService->generatePredictions($marketData, $newsArticles);

    // 4. Save to database
    $scoringService = new ScoringService();
    $scoringService->saveMarketData($today, $marketData);
    $scoringService->saveNewsArticles($today, $newsArticles);
    $scoringService->savePredictions($today, $tomorrow, $predictions);

    echo json_encode([
        'success' => true,
        'date' => $today,
        'marketDataCount' => count($marketData),
        'newsCount' => count($newsArticles),
        'predictions' => $predictions
    ]);

} catch (Exception $e) {
    error_log("Prediction run failed: " . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
