<?php
/**
 * Daily Scoring Cron Job
 * Run this script daily at 9 AM CET to score predictions
 */

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../services/YahooFinanceService.php';
require_once __DIR__ . '/../services/ScoringService.php';

echo "========================================\n";
echo "Running Daily Scoring Task\n";
echo "Time: " . date('c') . "\n";
echo "========================================\n\n";

try {
    $today = date('Y-m-d');
    $yesterday = date('Y-m-d', strtotime('-1 day'));

    // 1. Fetch today's market data
    echo "Fetching today's market data for scoring...\n";
    $yahooService = new YahooFinanceService();
    $marketData = $yahooService->fetchAllEuropeanIndices();
    echo "Fetched data for " . count($marketData) . " indices\n\n";

    // 2. Save market data
    $scoringService = new ScoringService();
    $scoringService->saveMarketData($today, $marketData);
    echo "Market data saved\n\n";

    // 3. Score yesterday's predictions
    echo "Scoring yesterday's predictions...\n";
    $scores = $scoringService->scorePredictions($yesterday, $today);

    echo "========================================\n";
    echo "Scoring Results\n";
    echo "========================================\n";
    echo "Total Predictions: " . $scores['total_predictions'] . "\n";
    echo "Correct: " . $scores['correct_predictions'] . "\n";
    echo "Accuracy: " . number_format($scores['accuracy_percent'], 2) . "%\n";
    echo "========================================\n";
    echo "Daily Scoring Task Completed\n";
    echo "========================================\n";

    exit(0);

} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    echo $e->getTraceAsString() . "\n";
    exit(1);
}
